% two subrutines
% first calculated base electrode
% result:  VZ_base  nanotransitor on top of the nanomagnet 

clear all

k=0.8;   %points per nm


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%make base for nanotransistor
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


    %%%%%%%at first make  ellips to cover
    nanomagnet_size=70; % basic ellipse size, fabricated before
    el_sizeNano=50; % in nm 
    el_ratio=1/1.4;  % usualy 1.4
    el_contact=[60 1000]; %%% Y length of contact electrode nm, X length should be less than ellipse!!!! width should be less or equal to ellips size
    %el_pad=[1500 2500]; %[2500 2000];  % electrode pad 
    base_gap=310; %gap to base from fabricated nanocontact
    base_thickness=70;
     
    EllipseGap=10;  % gap inside ellipse of contact
     
    %metal_gap=50;
    myAngle=45;    % opening angle   usualy 35 deg
    base_contact=[100 1000];
    base_pad=[1500 2500];  % base pad Y coordinate need to be calculated
    %!!!!!! pad Y should be used so that ellipse be at center 
    %base_pad(2)=el_contact(2)+el_pad(2);
    MyName=['base' num2str(nanomagnet_size) 'Single']; 
    EllipseInLineWidth=8; %nm   inline inside ellipse
    PadsInLineWidth=15; %nm
    ContactInLineWidth=15; %nm
    BaseInLineGap=45; % gap of base to inner inline
    BaseOutLineGap=45; % gap of base to extra inline
    InlineContactEllipse='non'; %'non'  'yes' use when problem with con
     DoEllipseCenter='non'; % 'yes' 'non'
     UpBaseContactInLineWidth=10;
     DoEllipseCenter='yes'; % 'yes' 'non'
     DoContactCenter='non';  %  'yes' non
    
%%%%%%%%%%%%%%%%%%%%%%%%new
%%%%%%%%%%%%%%%%%%%%%%%%%
      global AngleToTurn
    AngleToTurn=180;
UpMoveBase=0; %nm
%%%%%%%%%%%%%
    % everything should start from basic ellipse 
    Ellpse_open=nanomagnet_size*0.5;
    %generate semi elipse size
    Selipse_size=nanomagnet_size;
    %myAngle= atan(Ellpse_open/Selipse_size/el_ratio)/pi*180
        fi=myAngle:1:(360-myAngle);
    for j=1:length(fi)
    MyMag(j,2)=0.5*nanomagnet_size*cos(fi(j)*pi/180)/el_ratio;
    MyMag(j,1)=0.5*nanomagnet_size*sin(fi(j)*pi/180)*el_ratio;
     dydx=MyMag(j,1)/MyMag(j,2)/el_ratio^2;
    Norm=sqrt(1+dydx^2);
    EllipNorm(j,1)=dydx/Norm;EllipNorm(j,2)=1/Norm;
    if fi(j)>90&fi(j)<=270
      EllipNorm(j,2)=-EllipNorm(j,2);
      EllipNorm(j,1)=-EllipNorm(j,1);
  end
    MyMag0(j,2)=MyMag(j,2)-EllipNorm(j,2)*(nanomagnet_size-el_sizeNano)/2;
    MyMag0(j,1)=MyMag(j,1)-EllipNorm(j,1)*(nanomagnet_size-el_sizeNano)/2;;
    end
    %figure(1);plot(EllipNorm(:,1),EllipNorm(:,2));return
%%%%%  
    MainEl=MyMag;  % that is semi of main ellipse
    
    MyStep=el_sizeNano-EllipseInLineWidth*2;
    myAngle= atan(Ellpse_open/Selipse_size/el_ratio)/pi*180;;
    for j=1:length(fi)
    MyInLine(j,2)=MyMag0(j,2)-EllipNorm(j,2)*EllipseInLineWidth;
    MyInLine(j,1)=MyMag0(j,1)-EllipNorm(j,1)*EllipseInLineWidth;
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    DownInLine(:,1)=[MyMag0(:,1);flipud(MyInLine(:,1))];DownInLine(:,2)=[MyMag0(:,2);flipud(MyInLine(:,2))];
    clear MyMag; clear MyInLine; clear MyMag0;
    %figure(1); clf;hold on;plotJ01(DownInLine); ;hold off; return
    %%%%%%%%%%%%%

    %generate semi elipse size
    Selipse_size=nanomagnet_size;
    myAngle= atan(Ellpse_open/Selipse_size/el_ratio)/pi*180;;
        fi1=-myAngle:1:myAngle;
    for j=1:length(fi1)
    MyMag(j,2)=0.5*Selipse_size*cos(fi1(j)*pi/180)/el_ratio;
    MyMag(j,1)=0.5*Selipse_size*sin(fi1(j)*pi/180)*el_ratio;
         dydx=MyMag(j,1)/MyMag(j,2)/el_ratio^2;
    Norm=sqrt(1+dydx^2);
    NormTEMP(j,1)=dydx/Norm;NormTEMP(j,2)=1/Norm;

    MyMag0(j,2)=MyMag(j,2)-NormTEMP(j,2)*(nanomagnet_size-el_sizeNano)/2;
    MyMag0(j,1)=MyMag(j,1)-NormTEMP(j,1)*(nanomagnet_size-el_sizeNano)/2;;
    end
    UpPoint=MyMag0(round(length(fi1)/2),2);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%
    
    %Ellpse_open=el_sizeNano;
    %generate semi elipse size
    %Selipse_size=el_sizeNano-EllipseInLineWidth*2;
    %myAngle= atan(Ellpse_open/Selipse_size/el_ratio)/pi*180;;

    for j=1:length(fi1)
    MyInLine(j,2)=MyMag0(j,2)-NormTEMP(j,2)*EllipseInLineWidth;
    MyInLine(j,1)=MyMag0(j,1)-NormTEMP(j,1)*EllipseInLineWidth;
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    UpInLine(:,1)=[MyMag0(:,1);flipud(MyInLine(:,1))];UpInLine(:,2)=[MyMag0(:,2);flipud(MyInLine(:,2))];
    clear MyMag; clear MyInLine; clear MyMag0
%figure(1); clf;hold on;plotJ01(DownInLine);plotJ01(UpInLine); ;hold off; return
       
            %%%%%%%generate inner of ellipse
            % for our ellipse x^2/ellip+y^2*ellip=1  dy/dx=-x/y*ellip^2;
            % (1,dy/dx) touch; norm (-dy/dx,1)=(x/y*ellipt^2,1) or -(x/y*ellipt^2,1)
    fi2=2:2:358;
    for j=1:length(fi2)
    InnerCir(j,1)=nanomagnet_size*0.5*cos(fi2(j)*pi/180)*el_ratio;
    InnerCir(j,2)=nanomagnet_size*0.5*sin(fi2(j)*pi/180)/el_ratio;
    dydx=InnerCir(j,1)/InnerCir(j,2)/el_ratio^2;
    Norm=sqrt(1+dydx^2);
    UniV(1)=dydx/Norm;UniV(2)=1/Norm;
    if fi2(j)>180
      UniV=-UniV;
     end
    InnerC(j,1)=InnerCir(j,1)-((nanomagnet_size-el_sizeNano)/2+EllipseInLineWidth+EllipseGap)*UniV(1);
    InnerC(j,2)=InnerCir(j,2)-((nanomagnet_size-el_sizeNano)/2+EllipseInLineWidth+EllipseGap)*UniV(2);
    % for metal 
    %MetalC(j,1)=InnerCir(j,1)-metal_gap*UniV(1);
    %MetalC(j,2)=InnerCir(j,2)-metal_gap*UniV(2);
    end
    %figure(1); clf;hold on;plotJ01(DownInLine);plotJ01(UpInLine);plotJ01(InnerC) ;hold off; return
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%% now pad
    %%%%%%%%%%%% generate thin contact
    %widining describes length of small electrdes passing through the gap
    dd=el_sizeNano*el_ratio/2;
 widining=nanomagnet_size/2+base_gap+base_thickness/10;
 
  UpBaseContact=[-dd widining; -dd 0; dd 0;dd widining; 2*el_contact(1) el_contact(2);-2*el_contact(1) el_contact(2)];
     UpBaseContactDown=[-dd widining; -dd 0; dd 0;dd widining; ];
    UpBaseContactUp=[-dd widining; dd widining; 2*el_contact(1) el_contact(2);-2*el_contact(1) el_contact(2)];
 
 
     %UpBaseContact=[-el_contact(1)/2 widining; -el_contact(1)/2 0; el_contact(1)/2 0;el_contact(1)/2 widining; 2*el_contact(1) el_contact(2);-2*el_contact(1) el_contact(2)];
     %UpBaseContactDown=[-el_contact(1)/2 widining; -el_contact(1)/2 0; el_contact(1)/2 0;el_contact(1)/2 widining; ];
    %UpBaseContactUp=[-el_contact(1)/2 widining; el_contact(1)/2 widining; 2*el_contact(1) el_contact(2);-2*el_contact(1) el_contact(2)];
     UpBaseContact(:,2)=UpBaseContact(:,2)+UpPoint;%(el_sizeNano-metal_gap)/1.5;
     UpBaseContactUp(:,2)=UpBaseContactUp(:,2)+UpPoint;UpBaseContactDown(:,2)=UpBaseContactDown(:,2)+UpPoint;%
     %[BaseContactConLine, BaseContactArea]=InLineObject(BaseContact,EllipseInLineWidth);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%base pad

UpBasePad=[UpBaseContact(5,1) 0;UpBaseContact(6,1) 0; -base_pad(1)/2 base_pad(2);base_pad(1)/2 base_pad(2)];
    UpBasePad(:,2)=UpBasePad(:,2)+UpBaseContact(5,2);
    %[BasePadLine, BasePadArea]=InLineObject(BasePad,PadsInLineWidth);
%%%
% adjust sizes within 5 um
UpBasePad(4,2)=2450;UpBasePad(3,2)=2450;

    clear MyMag; clear MyInLine;  

    %figure(1); clf;hold on;plotJ01(DownInLine); plotJ01(UpInLine);plotJ01(InnerC);
    %plotJ01(UpBasePad);plotJ01(UpBaseContact);
    %;hold off; return
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%base
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%inner inline

    
    for j=1:length(fi)
    MyMag(j,2)=MainEl(j,2)+EllipNorm(j,2)*base_gap;
    MyMag(j,1)=MainEl(j,1)+EllipNorm(j,1)*base_gap;
    end
%%%
       ElShift=base_gap+EllipseInLineWidth; 
    for j=1:length(fi)
    MyInLine(j,2)=MainEl(j,2)+EllipNorm(j,2)*ElShift;
    MyInLine(j,1)=MainEl(j,1)+EllipNorm(j,1)*ElShift;
    end
    BaseInnerInLine(:,1)=[MyMag(:,1);flipud(MyInLine(:,1))];BaseInnerInLine(:,2)=[MyMag(:,2);flipud(MyInLine(:,2))];
    clear MyMag; clear MyInLine;
    %figure(1); clf;hold on;plotJ01(DownInLine); plotJ01(UpInLine);plotJ01(InnerC);plotJ01(BaseInnerInLine);;hold off; return
 %%%%%%%%%%%%%%% base   main
        ElShift=ElShift+BaseInLineGap;
    for j=1:length(fi)
    MyMag(j,2)=MainEl(j,2)+EllipNorm(j,2)*ElShift;
    MyMag(j,1)=MainEl(j,1)+EllipNorm(j,1)*ElShift;
    end
%%%
       ElShift=ElShift+base_thickness-PadsInLineWidth-BaseInLineGap-BaseOutLineGap-PadsInLineWidth; 
    for j=1:length(fi)
    MyInLine(j,2)=MainEl(j,2)+EllipNorm(j,2)*ElShift;
    MyInLine(j,1)=MainEl(j,1)+EllipNorm(j,1)*ElShift;
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    BaseMain(:,1)=[MyMag(:,1);flipud(MyInLine(:,1))];BaseMain(:,2)=[MyMag(:,2);flipud(MyInLine(:,2))];
    clear MyMag; clear MyInLine;
   %%%%%%%%%%%%%%% base   outer inline
        ElShift=ElShift+BaseOutLineGap;
    for j=1:length(fi)
    MyMag(j,2)=MainEl(j,2)+EllipNorm(j,2)*ElShift;
    MyMag(j,1)=MainEl(j,1)+EllipNorm(j,1)*ElShift;
    end
%%%
       ElShift=ElShift+PadsInLineWidth; 
    for j=1:length(fi)
    MyInLine(j,2)=MainEl(j,2)+EllipNorm(j,2)*ElShift;
    MyInLine(j,1)=MainEl(j,1)+EllipNorm(j,1)*ElShift;
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    BaseOutInLine(:,1)=[MyMag(:,1);flipud(MyInLine(:,1))];BaseOutInLine(:,2)=[MyMag(:,2);flipud(MyInLine(:,2))];
    clear MyMag; clear MyInLine;  
    
    
    %figure(1); clf;hold on;plotJ01(DownInLine); plotJ01(UpInLine);plotJ01(InnerC);
    %plotJ01(BaseMain); plotJ01(BaseOutInLine);plotJ01(BaseInnerInLine);;hold off; return

    %%%%%%%%%%%% generate thin contact
   
     BaseContact=[base_contact(1)/2 0;-base_contact(1)/2 0;-base_contact(1)/2 -base_contact(2);base_contact(1)/2 -base_contact(2)];
     
     
     BaseContact(:,2)=BaseContact(:,2)-(ElShift+el_sizeNano/2)-2*EllipseInLineWidth-1*PadsInLineWidth;
     
     BaseContact(:,2)=BaseContact(:,2)-UpMoveBase;
     [BaseContactConLine, BaseContactArea]=InLineObject(BaseContact,EllipseInLineWidth);
     %%%%%%%%%%%%%%%%%%% shift base
      BaseOutInLine(:,2)=BaseOutInLine(:,2)-UpMoveBase;
     BaseMain(:,2)=BaseMain(:,2)-UpMoveBase;
     BaseInnerInLine(:,2)=BaseInnerInLine(:,2)-UpMoveBase;
     
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%base pad
BasePad=[BaseContact(4,1) 0;BaseContact(3,1) 0; -base_pad(1)/2 -base_pad(2);base_pad(1)/2 -base_pad(2)];
    BasePad(:,2)=BasePad(:,2)+BaseContact(4,2);
    % adjust sizes to be within 5 um
BasePad(4,2)=-2450;BasePad(3,2)=-2450;
    [BasePadLine, BasePadArea]=InLineObject(BasePad,PadsInLineWidth);
   % figure(1); clf;hold on;plotJ01(DownInLine); plotJ01(UpInLine);plotJ01(InnerC);
   % plotJ01(BaseMain); plotJ01(BaseOutInLine);plotJ01(BaseInnerInLine);plotJ01(BaseContactConLine);
   % plotJ01(BaseContactArea);plotJ01(BasePadLine);plotJ01(BasePadLine);;
    %plotJ01(UpBasePad);plotJ01(UpBaseContact);hold off; return
    
    [UpBaseContactLine, UpBaseContactArea]=InLineObject(flipud(UpBaseContact),UpBaseContactInLineWidth);
    UpBaseContactLine=flipud(UpBaseContactLine); UpBaseContactArea=flipud(UpBaseContactArea);
    
    [UpBaseContactLineUp, UpBaseContactAreaUp]=InLineObject(flipud(UpBaseContactUp),UpBaseContactInLineWidth);
    UpBaseContactLineUp=flipud(UpBaseContactLineUp); UpBaseContactAreaUp=flipud(UpBaseContactAreaUp);   
     [UpBaseContactLineDown, UpBaseContactAreaDown]=InLineObject(flipud(UpBaseContactDown),UpBaseContactInLineWidth);
    UpBaseContactLineDown=flipud(UpBaseContactLineDown); UpBaseContactAreaDown=flipud(UpBaseContactAreaDown);
    
    [UpBasePadLine, UpBasePadArea]=InLineObject(UpBasePad,PadsInLineWidth);
    
    MyShift=[2500 2500];MyShift2=[2500 2500];
     DownInLine1=ToJ01(DownInLine,MyShift); UpInLine1=ToJ01(UpInLine,MyShift);InnerC1=ToJ01(InnerC,MyShift);
    BaseMain1=ToJ01(BaseMain,MyShift); BaseOutInLine1=ToJ01(BaseOutInLine,MyShift);BaseInnerInLine1=ToJ01(BaseInnerInLine,MyShift);
    BaseContactConLine1=ToJ01(BaseContactConLine,MyShift);%UpBaseContactArea1=ToJ01(UpBaseContactArea,MyShift);
    BasePadArea1=ToJ01(BasePadArea,MyShift);
    BaseContactArea1=ToJ01(BaseContactArea,MyShift);BasePadLine1=ToJ01(BasePadLine,MyShift);
     UpBaseContactLine2=ToJ01(UpBaseContactLine,MyShift2);UpBaseContactArea2=ToJ01(UpBaseContactArea,MyShift2);
     UpBaseContactLineUp2=ToJ01(UpBaseContactLineUp,MyShift2);UpBaseContactAreaUp2=ToJ01(UpBaseContactAreaUp,MyShift2);
     UpBaseContactLineDown2=ToJ01(UpBaseContactLineDown,MyShift2);UpBaseContactAreaDown2=ToJ01(UpBaseContactAreaDown,MyShift2);
     UpBasePadLine2=ToJ01(UpBasePadLine,MyShift2);UpBasePadArea2=ToJ01(UpBasePadArea,MyShift2);
     
     
     
     %UpBaseContactArea21=UpBaseContactArea2(4:6,:);
     UpBaseContactArea21=UpBaseContactArea2(1:4,:);
     %UpBaseContactArea22(:,1)=[UpBaseContactArea2(4:6,1); UpBaseContactArea2(1,1)];
     %UpBaseContactArea22(:,2)=[UpBaseContactArea2(4:6,2) ;UpBaseContactArea2(1,2)];
     UpBaseContactArea22=UpBaseContactArea2;
     
     global plotJ01UseFill
     plotJ01UseFill=1;   % use plot with fill
     global plotJ01Color
         figure(1); clf;hold on;
         plotJ01Color='y'; %area
         plotJ01(BaseMain1); plotJ01(BaseContactArea1);plotJ01(BasePadArea1);plotJ01(UpBaseContactArea22);
          plotJ01(UpBasePadArea2);
              if DoEllipseCenter=='yes'
         plotJ01(InnerC1);
     end
               if DoContactCenter=='yes'
         plotJ01(UpBaseContactArea21);
       end
         plotJ01Color='r'; %extra line
          
    plotJ01(BaseOutInLine1);plotJ01(BaseContactConLine1);
    plotJ01(BasePadLine1);
     plotJ01(UpBaseContactLineUp2);
    plotJ01(UpBasePadLine2);
     
    plotJ01Color='g'; %inner line
plotJ01(DownInLine1);plotJ01(BaseInnerInLine1);plotJ01(UpBaseContactLineDown2);plotJ01(UpInLine1);

     
    grid on; ;hold off; 
     
  
     %%%%%%%%%%%%%%%%%%%saving
           MyNameS1=['ID/VZ_' MyName '\n'];
 
    myFileName1=['VZ_' MyName '.j01'];
 
    
      MySizes=findObjectSizes(UpBasePadArea);  % not all
    
    fid = fopen(myFileName1,'w');
     PrintSizesToFile;
     fprintf(fid,['* metal contact for tunnel transistor  for ' num2str(nanomagnet_size) ' nm  nanocontact ratio ' num2str(el_ratio) ' \n']);
     
     fprintf(fid,['*gap between nanomagnet and base  ' num2str(base_gap)  ' nm, gap between contact and base ' num2str(base_gap+(nanomagnet_size-el_sizeNano)/2) ' \n']);
     fprintf(fid,['* three explos 1 all area, 2 extrnal inline  3 inner inline   \n']);
     fprintf(fid,['*base thickness   ' num2str(base_thickness)  ' \n']);
     fprintf(fid,['* contact to base ' num2str(base_contact(1)) num2str(base_contact(2))  ' \n']);
     fprintf(fid,['* opening angle ' num2str(myAngle)   ' \n']);
     fprintf(fid,['*inline ellipse ' num2str(EllipseInLineWidth) ' nm pads ' num2str(PadsInLineWidth) ' nm contact' num2str(ContactInLineWidth) ' nm \n']);
     fprintf(fid,['*  inline gap distance ' num2str(EllipseGap) 'nm    \n']);
     fprintf(fid,['* BaseInLineGap ' num2str(BaseInLineGap) '  BaseInLineGap ' num2str(BaseInLineGap)  ' \n']);

    
    fprintf(fid,MyNameS1);
   %1
   if DoEllipseCenter=='yes'
     fprintf(fid,'* ellipse area  \n');        
    a=InnerC1;MyLayer=1; PrintToJ01;
   end
    %2
    fprintf(fid,'* ellipse upper Line bigger explosure \n');
    a=flipud(UpInLine1);MyLayer=3; PrintToJ01;
    %3
    fprintf(fid,'* ellipse Down Line snmaller explosure  \n');
    a=flipud(DownInLine1);MyLayer=3; PrintToJ01;
  %4
        fprintf(fid,'* base area  \n');
    a=BaseMain1;MyLayer=1; PrintToJ01;
    %5
            fprintf(fid,'* base upper line bigger intensity  \n');
    a=BaseOutInLine1;MyLayer=2; PrintToJ01;
    %6
            fprintf(fid,'*  base lower line smaller intensity  \n');
    a=BaseInnerInLine1;MyLayer=3; PrintToJ01;
        %7
    fprintf(fid,'* small connecting pad area  \n');
    a=BaseContactArea1;MyLayer=1; PrintToJ01;
        %8
   fprintf(fid,'* small connecting pad  Line  \n');
    a=BaseContactConLine1;MyLayer=2; PrintToJ01;
    

    

    %9
   fprintf(fid,'* BasePad Inline  \n');
    a=BasePadLine1;MyLayer=2; PrintToJ01;
  
    % 10 
       fprintf(fid,'* BasePad area  \n');
    a=BasePadArea1;MyLayer=1; PrintToJ01;
    

    % 12
           fprintf(fid,'* Up Pad  area \n');
    a=flipud(UpBasePadArea2);MyLayer=1; PrintToJ01;
        % 13
           fprintf(fid,'* Up Pad  line \n');
    a=flipud(UpBasePadLine2);MyLayer=2; PrintToJ01;
            % 14
              if DoContactCenter=='yes'
           fprintf(fid,'* Up contact Area close to contact \n');
    a=UpBaseContactArea21;MyLayer=1; PrintToJ01;
       end
              fprintf(fid,'* Up contact area far from contact  \n');
    a=(UpBaseContactArea22);MyLayer=1; PrintToJ01;
    
                 fprintf(fid,'* Up contact line down \n');
    a=(UpBaseContactLineDown2);MyLayer=3; PrintToJ01;
    
                      fprintf(fid,'* Up contact line up \n');
    a=(UpBaseContactLineUp2);MyLayer=2; PrintToJ01; 



    fprintf(fid,'EF');
    fclose(fid); 
    
    
    
    
    
    
    
    
    